package ru.yandex.tours.geo.partners

import ru.yandex.tours.geo.base.RegionBase
import ru.yandex.tours.model.geo.PartnerObject
import ru.yandex.tours.model.{Languages, LocalizedString}
import ru.yandex.tours.model.hotels.Partners.Partner

/**
  * Created by asoboll on 29.01.16.
  */

case class PartnerRegion(partner: Partner,
                         id: String,
                         name: LocalizedString,
                         category: PartnerCategories.Value = PartnerCategories.Unknown,
                         origType: Option[String] = None,
                         isDeparture: Boolean,
                         longitude: Double = 0.0,
                         latitude: Double = 0.0,
                         hotelsCount: Int,
                         synonyms: Set[String] = Set.empty,
                         parentId: Option[String] = None,
                         countryId: Option[String] = None)
  extends RegionBase[String] with PartnerObject {

  require(id != "", "Empty region ID")

  def originalId: String = PartnerRegion.originalId(id)

  def fullPartnerId: (Partner, String) = (partner, id)

  override def hashCode(): Int = id.hashCode

  override def equals(obj: Any): Boolean = obj match {
    case x: PartnerRegion =>
      (x.id == this.id) && (x.partner == this.partner)
    case other =>
      false
  }

  override def getName: String = name.values.get(Languages.ru).filterNot(_.isEmpty).
    orElse(name.values.get(Languages.en)).filterNot(_.isEmpty).
    orElse(synonyms.headOption).filterNot(_.isEmpty).
    orElse(name.allValues.headOption).filterNot(_.isEmpty).
    getOrElse("NO_NAME")
}

object PartnerCategories extends Enumeration {
  val Ignored = Value(-1, "Ignored")
  val Unknown = Value(0, "")
  val Country = Value(1, "Country")
  val Region = Value(2, "Region")
  val Resort = Value(3, "Resort")
  val RegionOrResort = Value(4, "City")
  val Other = Value(5, "Other")
}

object PartnerRegion {
  def originalId(id: String): String = id.replaceAll("_dup_[A-z]*_[0-9]*", "")
}

case class PartnerRegionHeader(id: String, partnerTree: PartnerTree) {
  def partner: Partner = partnerTree.partner

  def partnerRegion: PartnerRegion = partnerTree.region(id).getOrElse(sys.error(s"unknown region ($partner, $id)"))

  def name = partnerRegion.name

  def synonyms = partnerRegion.synonyms
}