package ru.yandex.tours.geo.partners

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDefWithDependencies, DataTypes}
import ru.yandex.tours.util.IO
import shapeless.{::, HNil}

/**
  * Created by asoboll on 13.03.17.
  */
object PartnerRegionsDef extends DataDefWithDependencies[PartnerTrees, PartnerRegionHotelCounts :: HNil] {

  override def dataType: DataType = DataTypes.partnerRegions

  override def dependsOn: Set[DataType] = Set(PartnerRegionHotelCounts.dataType)

  def parse(is: InputStream, dependencies: PartnerRegionHotelCounts :: HNil): PartnerTrees = {
    val hotelCounts = dependencies.head
    val allRegions = IO.readLines(is).flatMap { raw =>
      PartnerRegionParser.parse(raw, hotelCounts).toOption
        .flatMap(PartnerRegionParser.vashotelHack(_, hotelCounts))
    }

    val map = for {
      (partner, regions) <- allRegions.toIterable.groupBy(_.partner)
    } yield {
      val extendedRegions = PartnerTreeUtils.extendRegions(regions)
      val tree = PartnerTreeUtils.toMap(extendedRegions)
      partner -> new PartnerTree(partner, tree)
    }
    new PartnerTrees(map)
  }
}
