package ru.yandex.tours.geo.partners

import ru.yandex.tours.model.geo.PartnerObject
import ru.yandex.tours.util.Collections._

/**
  * Created by asoboll on 10.03.17.
  */
object PartnerTreeUtils {
  def extendRegions(map: Map[String, PartnerRegion]): Iterator[ExtendedPartnerRegion] = {
    val id2parentId = for {
      (id, region) <- map
      parentId <- region.parentId.filter(map.contains).filterNot(_ == id)
        .orElse(region.countryId.filter(map.contains).filterNot(_ == id))
    } yield id -> parentId

    val id2childrenId = id2parentId.inverse

    for {
      (id, region) <- map.iterator
    } yield ExtendedPartnerRegion(region, id2parentId.get(id), id2childrenId.getOrElse(id, Seq.empty))
  }

  def extendRegions(regions: TraversableOnce[PartnerRegion]): Iterator[ExtendedPartnerRegion] = {
    extendRegions(toMap(regions))
  }

  def toMap[PR <: PartnerObject](regions: TraversableOnce[PR]): Map[String, PR] = {
    regions.map(r => r.id -> r).toMap
  }
}
