package ru.yandex.tours.geo.partners

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.extdata.{DataTypes, ExtDataUpdateChecker}
import ru.yandex.tours.model.hotels.Partners._

/**
  * Created by asoboll on 25.03.16.
  */
class PartnerTrees(val values: Map[Partner, PartnerTree]) {
  def apply(partner: Partner): PartnerTree = values.getOrElse(partner, new PartnerTree(partner, Map.empty))

  def get(partner: Partner): Option[PartnerTree] = values.get(partner)

  def contains(partner: Partner): Boolean = values.contains(partner)

  def region(partner: Partner, id: String): Option[PartnerRegion] = get(partner).flatMap(_.region(id))
}

object PartnerTrees {
  def from(extDataService: ExtDataService,
           extDataUpdateChecker: ExtDataUpdateChecker,
           lazyLoad: Boolean = false): PartnerTrees = {
    val map = for {
      (partner, dt) <- DataTypes.partnerTrees
      tree = new MappedPartnerTreeHolder(dt).from(extDataService, extDataUpdateChecker, lazyLoad)
    } yield partner -> tree
    new PartnerTrees(map)
  }
}
