package ru.yandex.tours.hotels

import java.io.{File, FileOutputStream, InputStream}

import ru.yandex.tours.model.hotels.HotelsHolder
import ru.yandex.tours.model.hotels.HotelsHolder.Hotel
import ru.yandex.tours.util.{IO, Logging, ProtoIO}

/* @author berkut@yandex-team.ru */

object HotelIO extends Logging {

  def loadFromFile(file: File): Vector[Hotel] = {
    loadFromFileAsIterator(file).toVector
  }

  def loadFromStream(is: InputStream): Vector[Hotel] = ProtoIO.loadFromStream(is, HotelsHolder.Hotel.PARSER).toVector

  def loadFromFileAsIterator(file: File): Iterator[Hotel] = ProtoIO.loadFromFile(file, HotelsHolder.Hotel.PARSER)

  def loadFromFileAsIterator(path: String): Iterator[Hotel] = loadFromFileAsIterator(new File(path))

  def dumpToFile(hotels: TraversableOnce[HotelsHolder.Hotel], filename: String): Unit = {
    IO.using(new FileOutputStream(filename)) { os =>
      hotels.foreach(_.writeDelimitedTo(os))
    }
  }

}
