package ru.yandex.tours.hotels

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.billing.{BillingIndex, BillingIndexTrait}
import ru.yandex.tours.billing.BillingOffers.IdedOfferBilling
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.vertis.billing.Model.OfferBilling
import shapeless._

sealed trait HotelsBillingIndexTrait extends BillingIndexTrait[HotelsIndex :: HNil] {

  override def dependsOn: Set[DataType] = DataTypes.shardedHotels.dataTypes.toSet

  override protected def createIndex(map: Map[Long, IdedOfferBilling],
                                     dependencies: HotelsIndex :: HNil): BillingIndex = {
    val hotelsIndex = dependencies.head
    val extendedMap = for {
      (id, offer) <- map
      hotel <- hotelsIndex.getHotelById(id.toInt).toIterable
      partnerId <- hotel.partnerIds
    } yield partnerId.travelId.toLong -> offer
    new BillingIndex(extendedMap)
  }

  protected def idPrefix: String

  override protected def createIdedOffer(id: Long, offer: OfferBilling): IdedOfferBilling = {
    IdedOfferBilling(idPrefix + id, offer)
  }
}

object HotelsBillingIndex extends HotelsBillingIndexTrait {
  override def dataType: DataType = DataTypes.hotelBilling

  override protected def idPrefix: String = "h"
}

object CMHotelsBillingIndex extends HotelsBillingIndexTrait {
  override def dataType: DataType = DataTypes.cmHotelBilling

  override protected def idPrefix: String = "cmh"
}