package ru.yandex.tours.hotels

import java.io.{ByteArrayInputStream, SequenceInputStream}

import akka.actor.ActorRefFactory
import akka.stream.ActorMaterializer
import ru.yandex.tours.hotels.HotelsExport.Fields.Field
import ru.yandex.tours.util.spray.stream.StreamingResponseSupport
import ru.yandex.tours.util.spray.stream.bytestring.ByteStringStreamingResponse
import spray.routing.Directives._
import spray.routing.RequestContext

class HotelsExportMarshaller(hotelsExport: HotelsExport)
                            (implicit actorRefFactory: ActorRefFactory) extends StreamingResponseSupport {

  private implicit val materializer = ActorMaterializer()

  def marshallHotelsExport(fields: Iterable[Field], filter: (Field, String) => Boolean): RequestContext => Unit = {
    val headerIs = new ByteArrayInputStream((fields.toSeq.sortBy(_.id).mkString("\t") + "\n").getBytes)
    val bodyIs = hotelsExport.read(fields, filter)
    val is = new SequenceInputStream(headerIs, bodyIs)
    complete(new ByteStringStreamingResponse(is))
  }
}
