package ru.yandex.tours.hotels

import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.model.BaseModel.Point
import ru.yandex.tours.model.MapRectangle
import ru.yandex.tours.model.filter.HotelFilter
import ru.yandex.tours.model.geo.MapObject
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.model.hotels.HotelsHolder.{PartnerHotel, TravelHotel}
import ru.yandex.tours.model.hotels.Partners._
import ru.yandex.tours.model.util.Paging

import scala.collection.JavaConverters._

object HotelsIndex {
  def inRectangle(mapInfo: MapRectangle, candidates: Iterable[Hotel]): Iterable[Hotel] = {
    candidates.filter(hotel => mapInfo.contains(hotel.longitude, hotel.latitude))
  }

  def hasCoord(hotel: TravelHotel): Boolean = {
    hotel.hasPoint && !isEmptyPoint(hotel.getPoint)
  }

  def hasCoord(hotel: PartnerHotel): Boolean = {
    hotel.getRawHotel.hasPoint && !isEmptyPoint(hotel.getRawHotel.getPoint)
  }
  
  def isEmptyPoint(point: Point): Boolean = {
    point.getLongitude.abs < 1e-3 && point.getLatitude.abs < 1e-3
  }

  def isIndexable(hotel: TravelHotel): Boolean = {
    HotelsIndex.hasCoord(hotel) && hotel.getImagesList.asScala.nonEmpty && hotel.hasGeoId && hotel.getNameCount > 0
  }

  def empty: HotelsIndex = new MemoryHotelsIndex(Seq.empty, Tree.empty, HotelRatings.empty)
}

trait HotelsIndex {
  def hotels: Iterator[Hotel]

  def getHotel(partner: Partner, id: String): Option[Hotel]

  def getHotelById(id: Int): Option[Hotel]

  def getHotelsById(ids: Iterable[Int]): Map[Int, Hotel]

  def getHotels(ids: Iterable[Int], filters: Iterable[HotelFilter], mapRectangle: Option[MapRectangle]): Map[Int, Hotel]

  def getHotelsCount(ids: Iterable[Int], filters: Iterable[HotelFilter], mapRectangle: Option[MapRectangle]): Int

  def filter(ids: Iterable[Int], filters: Iterable[HotelFilter], mapRectangle: Option[MapRectangle]): Set[Int]

  def inRectangle(mapInfo: MapRectangle, maxSize: Int, filters: HotelFilter*): Seq[Hotel]

  def size: Int

  def near(hotel: MapObject, maxSize: Int, filters: HotelFilter*): Iterator[Hotel]

  def topInRegion(geoId: Int, maxSize: Int, filters: HotelFilter*): Iterator[Hotel]

  def hotelsCountInRegion(geoId: Int) : Int

  def getHotels(page: Paging, filters: HotelFilter*): Seq[Hotel]
  def getHotelsSorted(page: Paging, filters: HotelFilter*): Seq[Hotel]
  def count(filters: HotelFilter*): Int
}
