package ru.yandex.tours.hotels

import java.io.InputStream

import org.apache.commons.codec.binary.Base64
import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.{Image, Video}
import ru.yandex.tours.model.BaseModel.ProtoImage
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.util.Collections._
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.08.15
 */
class HotelsVideo(map: Map[Int, Video]) {
  def all: Seq[(Int, Video)] = map.toSeq
  def getVideo(hotelId: Int): Option[Video] = map.get(hotelId)
  def getVideo(hotel: Hotel): Option[Video] = {
    hotel.partnerIds.map(_.travelId).iterator
      .flatMap(id => getVideo(id))
      .headOption
  }
}

object HotelsVideo extends DataDef[HotelsVideo] {
  override def dataType: DataType = DataTypes.hotelsVideo

  override def parse(is: InputStream): HotelsVideo = {
    val videosMap = for {
      Tabbed(IntValue(hotelId), preview, video) <- IO.readLines(is)
    } yield {
      val image = Image.fromProto(ProtoImage.parseFrom(Base64.decodeBase64(preview)))
      hotelId -> Video(image, video)
    }
    new HotelsVideo(videosMap.toMap)
  }
}