package ru.yandex.tours.hotels

import java.io.File

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.extdata.{DataTypes, ExtDataUpdateChecker}
import ru.yandex.tours.yocto.YoctoShardHolder
import ru.yandex.tours.util.file.RichFile

object ShardedYoctoHotelsIndex {
  val SHARDS_COUNT = 25

  def fromDir(dir: File, hotelRatings: HotelRatings): YoctoHotelsIndex = {
    val dbs = DataTypes.shardedHotels.dataTypes.map {
      dt => new YoctoShardHolder(dir, dt, true).parseFile(dir / dt.getName)
    }
    new YoctoHotelsIndex(hotelRatings, dbs: _*)
  }

  def fromExtData(dir: File, hotelRatings: HotelRatings,
                  extDataService: ExtDataService, extDataUpdateChecker: ExtDataUpdateChecker,
                  lazyLoadResources: Boolean): YoctoHotelsIndex = {
    val dbs = DataTypes.shardedHotels.dataTypes.map {
      dt => new YoctoShardHolder(dir, dt, true).from(extDataService, extDataUpdateChecker, lazyLoadResources)
    }
    new YoctoHotelsIndex(hotelRatings, dbs: _*)
  }
}


