package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor

object AddressNumberFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    val result = for {
      aDigits <- ctx.context1.addressDigits
      bDigits <- ctx.context2.addressDigits
      if aDigits.nonEmpty && bDigits.nonEmpty
    } yield (aDigits & bDigits).size.toDouble / (aDigits | bDigits).size
    if (result.isEmpty) -1 else result.min
  }

  override def name: String = "address_number"
}
