package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor

object BoundedDistanceFeature extends FeatureExtractor[ClusteringContext] {

  private val MAX_DISTANCE_IN_KM = 1.8d
  private val DIVISOR = Math.log1p(MAX_DISTANCE_IN_KM)


  override def apply(ctx: ClusteringContext): Double = {
    ctx.distance.fold(-1d) { dist =>
      (Math.log1p(dist) min DIVISOR) / DIVISOR
    }
  }

  override def name: String = "bounded_distance"
}
