package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.util.ImageUtils

import scala.collection.JavaConverters._

object CountOfSimilarOnPHashFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    val aHashes = ctx.context1.pHashes
    val bHashes = ctx.context2.pHashes
    if (aHashes.isEmpty || bHashes.isEmpty) {
      -1
    } else {
      {
        for {
          x ← aHashes
          y ← bHashes
        } yield ImageUtils.pHashSimilarity(x, y)
      }.count(_ > THRESHOLD)
    }
  }

  private val THRESHOLD = 0.85

  override def name: String = "phash_similar_count"
}
