package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 19.04.16
 */
object HotelTypesFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    if (!ctx.context1.hasType || !ctx.context2.hasType) {
      -1d
    } else if (ctx.context1.hotelType == ctx.context2.hotelType) {
      1d
    } else {
      0d
    }
  }

  override def name: String = "same_hotel_type"
}
