package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.{ClusteringContext, HotelContext}
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.model.hotels.HotelsHolder.{HotelType, PartnerHotel}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.05.16
 */
object IsApartBoothFeature extends FeatureExtractor[ClusteringContext] {
  override def name: String = "is_apart_booth"

  private def isApart(hotel: HotelContext) = {
    hotel.hotelType == HotelType.APARTMENTS
  }

  override def apply(ctx: ClusteringContext): Double = {
    if (isApart(ctx.context1) && isApart(ctx.context2)) 1d
    else 0d
  }
}
