package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.{ClusteringContext, HotelContext}
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.model.hotels.Partners

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.05.16
 */
object IsBackaFeature extends FeatureExtractor[ClusteringContext] {
  override def name: String = "is_backa"

  private def isBacka(hotel: HotelContext) = {
    hotel.partnerId == Partners.backa.id
  }

  override def apply(ctx: ClusteringContext): Double = {
    if (isBacka(ctx.context1) || isBacka(ctx.context2)) 1d else 0d
  }
}
