package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 21.04.16
 */
object LocalDensityFeature extends FeatureExtractor[ClusteringContext] {

  private val MAX_HOTELS = 10000
  private val MAX_HOTELS_LOG1P = math.log1p(MAX_HOTELS)

  override def apply(ctx: ClusteringContext): Double = {
    val near = ctx.context1.nearHotelsCount + ctx.context2.nearHotelsCount
    (math.log1p(near) min MAX_HOTELS_LOG1P) / MAX_HOTELS_LOG1P
  }

  override def name: String = "local_density"
}
