package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.util.Vectors.cosine
import ru.yandex.tours.util.naming.TfIdfModel

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 20.04.16
 */
object LocalTfIdfCosFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    val f1 = ctx.context1.cleanedNameWordsVector
    val f2 = ctx.context2.cleanedNameWordsVector

    if (f1.length != f2.length) -1d
    else cosine(f1, f2)
  }

  override def name: String = "local_tf_idf_cos"
}
