package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.util.Vectors
import ru.yandex.tours.util.math.Auc

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.08.16
 */
object NNFeaturesCosAucFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    val result = for {
      aI <- ctx.context1.nnFeatures
      bI <- ctx.context2.nnFeatures
      sim = imageCosSimilarity(aI, bI)
      if !java.lang.Double.isNaN(sim)
    } yield sim
    if (result.isEmpty) 0
    else {
      val topMatch = result.sorted.reverse.take(20)
      Auc.of(topMatch)
    }
  }

  private def imageCosSimilarity(a: Array[Double], b: Array[Double]): Double = {
    // there are total 96 numbers. Each number is from -1 to 1. Max difference is 2.
    // So maximum distance is sqrt(96 * 4)

    if (a.length == 0 || b.length == 0) {
      0
    } else {
      assert(a.length == 96 && b.length == 96, "Wrong number of NN features")

      Vectors.cos(a, b)
    }
  }

  override def name: String = "nn_cos_auc"
}
