package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.util.ImageUtils
import ru.yandex.tours.util.math.Auc

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 04.08.16
 */
object PHashAucFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    val aHashes = ctx.context1.pHashes
    val bHashes = ctx.context2.pHashes
    if (aHashes.isEmpty || bHashes.isEmpty) {
      0d
    } else {
      val res = for {
        aHash <- aHashes
        bHash <- bHashes
      } yield ImageUtils.pHashSimilarity(aHash, bHash)
      val topMatch = res.sorted.reverse.take(20)
      Auc.of(topMatch)
    }
  }

  override def name: String = "phash_auc"
}
