package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.util.ImageUtils

import scala.collection.JavaConverters._

object PHashNearestFeature extends FeatureExtractor[ClusteringContext] {


  override def apply(ctx: ClusteringContext): Double = {
    val aHashes = ctx.context1.pHashes
    val bHashes = ctx.context2.pHashes
    if (aHashes.isEmpty || bHashes.isEmpty) {
      -1
    } else {
      val res = for {
        aHash <- aHashes
        bHash <- bHashes
      } yield ImageUtils.pHashSimilarity(aHash, bHash)
      res.max
    }
  }

  override def name: String = "phash_nearest"
}
