package ru.yandex.tours.hotels.clustering.features

import org.apache.commons.lang.StringUtils
import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 19.04.16
 */
object PhoneSuffixFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    if (ctx.context1.phones.isEmpty || ctx.context2.phones.isEmpty) return -1

    val result = for {
      aPhone <- ctx.context1.phones
      bPhone <- ctx.context2.phones
    } yield {
      val len = aPhone.length min bPhone.length
      val aReverse = aPhone.reverse
      val bReverse = bPhone.reverse
      val suffixLength = StringUtils.getCommonPrefix(Array(aReverse, bReverse)).length

      (suffixLength + 1) / (len + 1)
    }
    if (result.nonEmpty) result.max else -1
  }

  override def name: String = "phone_suffix_len"
}
