package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 19.04.16
 */
object SamePartnerFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    if (ctx.context1.partnerId == ctx.context2.partnerId) 0d else 1d
  }

  override def name: String = "same_partner"
}
