package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel

object StarsFeature extends FeatureExtractor[ClusteringContext] {


  override def apply(ctx: ClusteringContext): Double = {
    val a = ctx.context1.stars.getOrElse(0)
    val b = ctx.context2.stars.getOrElse(0)

    if (a == 0 || b == 0) {
      return -1
    }
    (a - b).abs match {
      case 0 => 1
      case 1 => 0.5
      case _ => 0
    }
  }

  override def name: String = "star"
}
