package ru.yandex.tours.hotels.clustering.features

import ru.yandex.tours.hotels.clustering.ClusteringContext
import ru.yandex.tours.ml.FeatureExtractor

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 19.04.16
 */
object UrlHostFeature extends FeatureExtractor[ClusteringContext] {

  override def apply(ctx: ClusteringContext): Double = {
    (ctx.context1.host, ctx.context1.host) match {
      case (Some(a), Some(b)) =>
        if (a == b) 1 else 0
      case _ => -1
    }
  }

  override def name: String = "url_host"
}
