package ru.yandex.tours.hotels.enrichers

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{CompositeDataDef, DataTypes}
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.model.hotels.Partners
import shapeless.{::, HNil}

import scala.collection.JavaConverters._

class BookingCountryGeoIdSetter(tree: Tree) extends GeoIdByPartnerHotelSetter {
  private val langVal2countryId = (for {
    country <- tree.regions
    (lang, value) <- country.name.values
  } yield (lang.toString, value.toLowerCase) -> country).toMap

  override def getGeoId(hotel: PartnerHotel): Option[RegionWithConfidence] = {
    if (hotel.getRawHotel.getPartner == Partners.booking.id) {
      val candidates = for {
        address <- hotel.getRawHotel.getAddressList.asScala
        lang = address.getLang
        value = address.getCountry
        country <- langVal2countryId.get((lang, value.toLowerCase))
      } yield country
      if (candidates.distinct.size == 1) {
        Some(RegionWithConfidence(candidates.head, 0.7))
      } else {
        None
      }
    } else {
      None
    }
  }
}

object BookingCountryGeoIdSetter extends CompositeDataDef[BookingCountryGeoIdSetter, Tree :: HNil] {
  override def dependsOn: Set[DataType] = Set(DataTypes.regions)

  override def from(dependencies: Tree :: HNil): BookingCountryGeoIdSetter = {
    val tree = dependencies.head
    new BookingCountryGeoIdSetter(tree)
  }
}

