package ru.yandex.tours.hotels.enrichers

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{CompositeDataDef, DataTypes}
import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import shapeless.{::, HNil}

class CountryGeoIdBySpanSetter(countries: Iterable[Region]) extends GeoIdByPartnerHotelSetter {
  override def getGeoId(hotel: PartnerHotel): Option[RegionWithConfidence] = {
    if (hotel.getRawHotel.hasPoint) {
      val point = hotel.getRawHotel.getPoint
      val candidates = countries.filter(_.boundingBox.contains(point.getLongitude, point.getLatitude))
      if (candidates.size == 1) {
        Some(RegionWithConfidence(candidates.head, 0.6))
      } else {
        None
      }
    } else {
      None
    }
  }
}

object CountryGeoIdBySpanSetter extends CompositeDataDef[CountryGeoIdBySpanSetter, Tree :: HNil] {
  override def dependsOn: Set[DataType] = Set(DataTypes.regions)

  override def from(dependencies: Tree :: HNil): CountryGeoIdBySpanSetter = {
    val tree = dependencies.head
    new CountryGeoIdBySpanSetter(tree.regions.filter(_.isCountry))
  }
}
