package ru.yandex.tours.hotels.enrichers

import ru.yandex.tours.geo.base.region
import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.geo.partners.{PartnerTrees, PartnerTree}
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner

class GeoIdByPartnerRegionSetter(geoMappingHolder: GeoMappingHolder, partnerTrees: PartnerTrees, yaTree: region.Tree)
  extends GeoIdByPartnerHotelSetter {

  def getGeoId(partner: Partner, partnerRegion: String): Option[RegionWithConfidence] = {
    for {
      tree <- partnerTrees.get(partner)
      geoId <- getGeoId(partnerRegion, partner, tree)
      region <- yaTree.region(geoId)
    } yield RegionWithConfidence(region, 1)
  }

  private def getGeoId(regionId: String, partner: Partner, tree: PartnerTree): Option[Int] = {
    tree.pathToRoot(regionId).flatMap(r => geoMappingHolder.getGeoId(partner, r.id)).headOption
  }

  override def getGeoId(hotel: PartnerHotel): Option[RegionWithConfidence] = {
    val rawHotel = hotel.getRawHotel
    if (rawHotel.hasRegionId) {
      getGeoId(Partners(hotel.getRawHotel.getPartner), rawHotel.getRegionId)
    } else {
      None
    }
  }
}
