package ru.yandex.tours.hotels.enrichers

import ru.yandex.tours.app.{Application, CommonDataHolders}
import ru.yandex.tours.extdata.ExtDataSupport
import ru.yandex.tours.geo.partners.PartnerTreesSupport
import shapeless.HNil

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 23.03.16
 */
trait GeoIdSettersSupport {
  this: Application with CommonDataHolders with ExtDataSupport with PartnerTreesSupport =>

  lazy val geoIdByPartnerSetter = new GeoIdByPartnerRegionSetter(geoMappingHolder, partnerTrees, regionTree)

  lazy val geoIdBySpanSetter: CountryGeoIdBySpanSetter = CountryGeoIdBySpanSetter
    .from(regionTree :: HNil, extDataUpdateChecker, lazyLoadResources)

  lazy val geoIdForBookingSetter: BookingCountryGeoIdSetter = BookingCountryGeoIdSetter
    .from(regionTree :: HNil, extDataUpdateChecker, lazyLoadResources)

  lazy val metaGeoIdSetter = new MetaGeoIdSetter(geoIdByPartnerSetter, geoIdBySpanSetter, geoIdForBookingSetter)

}
