package ru.yandex.tours.metro

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.Agencies.Metro
import ru.yandex.tours.util.Collections._
import ru.yandex.tours.util.ProtoIO
import ru.yandex.tours.util.graph.BfsWalker

import scala.collection.JavaConverters._

class MetroHolder(metros: Iterable[Metro]) {
  private val byIdMap = metros.map(m ⇒ m.getId → m).toMultiMap
  private val byCompositeIdMap = metros.map(m ⇒ MetroUtil.compositeId(m) → m).toMap
  private val byGeoIdMap = metros.groupBy(_.getGeoId)

  def byId(id: Int): List[Metro] = byIdMap.getOrElse(id, List.empty)
  def byCompositeId(id: String): Option[Metro] = byCompositeIdMap.get(id)
  def getConnected(id: Int): List[Metro] = {
    BfsWalker.walk[Int](id, id ⇒ {
      val metros = byId(id)
      val connected = metros.flatMap(m ⇒ m.getConnectedList.asScala.map(Int.unbox).flatMap(byId))
      (metros ++ connected).map(_.getId).toSet
    }).toList.flatMap(byId)
  }
  def byGeoId(geoId: Int): Seq[Metro] = byGeoIdMap.getOrElse(geoId, Seq.empty).toSeq
}

object MetroHolder extends DataDef[MetroHolder] {
  override def dataType: DataType = DataTypes.metro

  override def parse(is: InputStream): MetroHolder =
    new MetroHolder(ProtoIO.loadFromStream(is, Metro.PARSER).toVector)
}
