package ru.yandex.tours.ml

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 29.04.16
 */
class Features[T](features: FeatureExtractor[T]*) {

  def names: Seq[String] = {
    features.map(_.name)
  }

  def apply(obj: T): Array[Double] = {
    features.map(_.apply(obj)).toArray
  }
}
