package ru.yandex.tours.operators

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.HotelProvider

class HotelProviders(providers: List[HotelProvider]) extends SearchSources[HotelProvider](providers)

object HotelProviders extends DataDef[HotelProviders] {
  override def dataType: DataType = DataTypes.hotel_providers

  override def parse(is: InputStream): HotelProviders = new HotelProviders(SearchSources.parse(is, HotelProvider.apply))
}