package ru.yandex.tours.operators

import java.io.InputStream

import ru.yandex.tours.model.Source
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners._
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{AtSKV, DoubleValue, IntValue, Tabbed}

object SearchSources {
  def parse[T <: Source](is: InputStream, create: (Int, Map[Partner, String], String, String, Double) => T): List[T] = {
    val operators = IO.readLines(is).map {
      case Tabbed(IntValue(id), name, code, DoubleValue(priority), AtSKV(rawMapping)) =>
        val mapping =
          for ((partner, operatorCode) <- rawMapping)
            yield Partners.withName(partner) -> operatorCode
        create(id, mapping, name, code, priority)
    }
    operators.toList
  }
}

abstract class SearchSources[T <: Source](operators: List[T]) {
  private val byId = operators.map(o => o.id -> o).toMap
  private val byCode = operators.flatMap(o => o.partner2id.map(_ -> o)).toMap

  def getAll: Seq[T] = operators

  def getForPartners(partners: Set[Partner]): Iterable[T] = operators.filter(o ⇒ (o.partners & partners).nonEmpty)

  def getById(id: Int): Option[T] = byId.get(id)

  def getByCode(partner: Partner, code: String): Option[T] = byCode.get(partner -> code)
}
