package ru.yandex.tours.operators

import akka.actor.ActorSystem
import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.util.Logging

import scala.concurrent.{Future, ExecutionContext}
import scala.concurrent.duration.FiniteDuration
import scala.concurrent.duration._
import scala.util.{Failure, Success}

class TourOperatorsState(tourOperators: TourOperators,
                         availability: TourOperatorAvailability,
                         updateTime: FiniteDuration)
                        (implicit as: ActorSystem, ec: ExecutionContext) extends Logging {

  // TourOperator -> isAlive
  @volatile
  private var currentState = tourOperators.getAll.map(_ -> true).toMap

  def getAlive: Iterable[TourOperator] = currentState.filter(_._2).keys

  def getAvailability: Future[Map[TourOperator, Availability]] = availability.getAvailability(tourOperators.getAll)

  as.scheduler.schedule(0.millis, updateTime) {
    availability.getAvailability(tourOperators.getAll) onComplete {
      case Success(result) => currentState = result.map { case (to, av) => to -> av.isAlive }
      case Failure(e) => log.warn("Can not update operators availability!", e)
    }
  }
}
