package ru.yandex.tours.ota

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.ota.OnlineTourAgency
import ru.yandex.tours.util.parsing.{AtSKV, IntValue, Tabbed}

class OnlineTourAgencies(val agencies: List[OnlineTourAgency])

object OnlineTourAgencies extends DataDef[OnlineTourAgencies]{
  override def dataType: DataType = DataTypes.onlineAgencies

  override def parse(is: InputStream): OnlineTourAgencies = {
    val agencies = scala.io.Source.fromInputStream(is).getLines().map {
      case Tabbed(IntValue(id), name, billingId, secretKey, actionUrl, hotelUrl, regionsUrl, operatorsUrl, AtSKV(headers), authToken) =>
        OnlineTourAgency(id, name, billingId, secretKey, actionUrl, hotelUrl, regionsUrl, operatorsUrl, authToken, headers.toList)
    }
    new OnlineTourAgencies(agencies.toList)
  }
}
