package ru.yandex.tours.parsing

import java.io.InputStream
import javax.xml.stream.XMLStreamReader

import scala.collection.mutable

abstract class AbstractBackaXmlParser[T] extends AbstractCompanyXmlParser[T] {

  override def parseInputStream(is: InputStream): Iterable[T] = parseInputStream(is, "companies", "company")

  override def parseFile(filename: String): mutable.Buffer[T] = parseFile(filename, "companies", "company")

  protected def parsePhones(parser: XMLStreamReader) = {
    val result = mutable.Buffer.empty[String]
    parseTag(parser, "phones") {
      case "phone" =>
        if (isNotHidden(parser)) {
          parseTag(parser, "phone") {
            case "formatted" => result += parseString(parser)
          }
        }
    }
    result
  }

  protected def isNotHidden(parser: XMLStreamReader) = !getOptAttribute(parser, "hide").contains("1")
}
