package ru.yandex.tours.parsing

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataTypes, DataDef}
import ru.yandex.tours.model.BaseModel.Pansion
import ru.yandex.tours.util.parsing.Tabbed
import ru.yandex.tours.util.Collections._

import scala.io.Source

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.05.15
 */
class PansionUnifier(aliases: Map[String, Pansion]) {
  def unify(rawPansion: String): Option[Pansion] = {
    val normalized = PansionUnifier.normalize(rawPansion)
    if (normalized.isEmpty) {
      Some(Pansion.RO)
    } else {
      aliases.get(normalized)
        .orElse(if (normalized.contains("AI")) Some(Pansion.AI) else None)
    }
  }

  def unify(raw: Seq[String]): Option[Pansion] = {
    raw.toIterator.flatMap(unify(_)).headOption
  }
}

object PansionUnifier extends DataDef[PansionUnifier] {
  override def dataType: DataType = DataTypes.pansions

  override def parse(is: InputStream): PansionUnifier = {
    val aliases = Source.fromInputStream(is).getLines().map {
      case Tabbed(pansion, alias) =>
        normalize(alias) -> Pansion.valueOf(pansion)
    }.toMap
    new PansionUnifier(aliases)
  }

  def normalize(raw: String): String = raw.trim.replaceAll("\\+", "").replaceAll(" ", "_").toUpperCase

  lazy val empty: PansionUnifier = new PansionUnifier(Map.empty)
}
