package ru.yandex.tours.partners

import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.search.{ExtendedBaseRequest, ExtendedHotelSearchRequest, ExtendedOfferSearchRequest}
import spray.http.Uri

import scala.util.Try

object CommonHotelProviderHttp {
  def getSearchUrl(request: ExtendedBaseRequest,
                   searchUrl: String,
                   partner: Partner,
                   hotelsIndex: HotelsIndex,
                   geoMapping: GeoMappingHolder): Try[Uri] = Try {
    val adults = request.hotelRequest.adults
    val children = request.hotelRequest.kidsAges
    var requestParams = Map(
      "adults" -> adults.toString,
      "date_from" -> request.hotelRequest.when.toString,
      "nights" -> request.hotelRequest.nights.toString
    )
    if (children.nonEmpty) {
      requestParams += "children" -> children.mkString(",")
    }
    def getPartnerHotelIds(ids: Seq[Int]) = hotelsIndex.getHotelsById(ids).values.flatMap(_.partnerId(partner))
    request match {
      case ExtendedHotelSearchRequest(_, _, Some(ids)) =>
        requestParams += "hotel_ids" -> getPartnerHotelIds(ids).mkString(",")
      case hotelRequest: ExtendedHotelSearchRequest =>
        val geoId = hotelRequest.to
        val region = geoMapping.getPartnerCity(partner, geoId).orElse(geoMapping.getPartnerCountry(partner, geoId)).getOrElse(throw new Exception(s"Unknown destination $geoId by $partner"))
        requestParams += "region_id" -> region
      case tourRequest: ExtendedOfferSearchRequest =>
        val hotelIds = getPartnerHotelIds(Seq(tourRequest.hotelId))
        if (hotelIds.isEmpty) {
          throw new Exception(s"No mapping for hotel with id ${tourRequest.hotelId} for partner $partner")
        }
        requestParams += "hotel_ids" -> hotelIds.mkString(",")
      case req => throw new Exception(s"$partner searcher doesn't support such request: $req")
    }
    Uri(searchUrl).withQuery(requestParams)
  }
}
