package ru.yandex.tours.personalization

case class UserIdentifiers(yuid: Option[String], uid: Option[String], login: Option[String]) {
  def isEmpty: Boolean = login.isEmpty && yuid.isEmpty
}

object UserIdentifiers {
  def empty: UserIdentifiers = UserIdentifiers(None, None, None)

  def apply(yuid: String, uid: String, login: String): UserIdentifiers = {
    new UserIdentifiers(
      Option(yuid).filter(_.nonEmpty),
      Option(uid).filter(_.nonEmpty),
      Option(login).filter(_.nonEmpty)
    )
  }
}