package ru.yandex.tours.prices

import org.joda.time.DateTime
import ru.yandex.tours.calendar.Calendar.FlightDay
import ru.yandex.tours.model.filter.SnippetFilter
import ru.yandex.tours.model.search.SearchDates

import scala.concurrent.Future
import scala.concurrent.duration.FiniteDuration

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.11.15
 */
trait PriceSearcher {

  /** search last prices for given parameters */
  def searchLastPrices(from: Int, to: Int, ages: Seq[Int],
                       dates: SearchDates,
                       filters: Seq[SnippetFilter],
                       freshness: FiniteDuration): Future[Seq[Price]]

  def searchLastDirectionPrices(from: Int, ages: Seq[Int],
                                dates: SearchDates,
                                filters: Seq[SnippetFilter],
                                freshness: FiniteDuration): Future[Seq[DirectionPrice]]

  /** search for price freshness for given parameters */
  def getFreshness(from: Int, to: Int, ages: Seq[Int],
                   dates: SearchDates,
                   freshness: FiniteDuration): Future[Map[FlightDay, DateTime]]
}
