package ru.yandex.tours.resorts

import java.io.InputStream

import org.joda.time.LocalDate
import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.util.DateInterval
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 31.03.16
 */
class Brandings(intervals: Seq[(DateInterval, String)]) {
  def getActive(date: LocalDate): Option[String] = {
    intervals.find(_._1.isInside(date)).map(_._2)
  }
}

object Brandings extends DataDef[Brandings] {
  override def dataType: DataType = DataTypes.brandings

  override def parse(is: InputStream): Brandings = {
    val data = IO.readLines(is).map {
      case Tabbed(startDate, endDate, name) =>
        val interval = DateInterval(LocalDate.parse(startDate), LocalDate.parse(endDate))
        (interval, name)
    }.toVector
    new Brandings(data)
  }
}
