package ru.yandex.tours.search

import java.time.Month

import org.joda.time.LocalDate
import ru.yandex.tours.calendar.Calendar.FlightDay
import ru.yandex.tours.model.BaseModel.Currency
import ru.yandex.tours.model.Languages
import ru.yandex.tours.model.search.{EmptySearchFilter, HotelSearchRequest, SearchType}
import ru.yandex.tours.model.search.SearchType.SearchType
import ru.yandex.tours.util.lang.Dates._

object DefaultRequestGenerator {
  def getDefaultFlightDay: FlightDay = {
    val now = LocalDate.now
    FlightDay(now.nextWeekSaturday, DEFAULT_NIGHTS)
  }

  val MOSCOW_GEO_ID = Defaults.MOSCOW_GEO_ID

  val DEFAULT_NIGHTS = 7

  def getDefaultNights(context: SearchType): Int = context match {
    case SearchType.ROOMS => 1
    case SearchType.TOURS => DEFAULT_NIGHTS
  }

  //two adults
  val DEFAULT_AGES = Defaults.TWO_ADULTS

  def getDefaultRequest(from: Int, to: Int, month: Month, context: SearchType): HotelSearchRequest = {
    HotelSearchRequest(
      from = from, to = to,
      nights = getDefaultNights(context),
      when = (LocalDate.now.nearMonthStart(month) max LocalDate.now).nextSaturday,
      ages = Defaults.TWO_ADULTS,
      flexWhen = false,
      flexNights = false,
      currency = Currency.RUB,
      lang = Languages.ru,
      filter = EmptySearchFilter
    )
  }
}
