package ru.yandex.tours.search

import ru.yandex.tours.model.search.SearchResults.{HotelSearchResult, OfferSearchResult}

import scala.concurrent.duration._

object SearchUtil {
  private val hungRequestTtl = 1.minute

  def isFailed(result: HotelSearchResult): Boolean = {
    val progress = result.getProgress
    progress.getIsFinished &&
      result.getHotelSnippetCount == 0 &&
      progress.getOperatorFailedCount > 0
  }

  def isFailed(result: OfferSearchResult): Boolean = {
    val progress = result.getProgress
    progress.getIsFinished &&
      result.getOfferCount == 0 &&
      progress.getOperatorFailedCount > 0
  }

  def isHung(result: HotelSearchResult): Boolean = {
    !result.getProgress.getIsFinished &&
      result.getUpdated < System.currentTimeMillis() - hungRequestTtl.toMillis
  }

  def isHung(result: OfferSearchResult): Boolean = {
    !result.getProgress.getIsFinished &&
      result.getUpdated < System.currentTimeMillis() - hungRequestTtl.toMillis
  }
}
