package ru.yandex.tours.services

import ru.yandex.tours.model.search._
import ru.yandex.tours.model.search.SearchResults.{ActualizedOffer, FlightSearchResult, HotelSearchResult, OfferSearchResult}

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.03.16
 */
trait CalendarPushService {
  def saveTourSnippets(request: HotelSearchRequest, response: HotelSearchResult): Future[Unit]
  def saveTourOffers(request: OfferSearchRequest, response: OfferSearchResult): Future[Unit]

  def saveActualization(request: GetOfferRequest, actualized: ActualizedOffer): Future[Unit]

  def saveRoomSnippets(request: HotelSearchRequest, response: HotelSearchResult): Future[Unit]
  def saveRoomOffers(request: OfferSearchRequest, response: OfferSearchResult): Future[Unit]

  def saveFlights(request: FlightSearchRequest, response: FlightSearchResult): Future[Unit]
}
