package ru.yandex.tours.services

import org.joda.time.LocalDate
import ru.yandex.tours.model.Calendar
import ru.yandex.tours.model.util.DateInterval

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.02.16
 */
trait CalendarService {

  def getFlightMatrix: Future[Calendar.FlightMatrix]

  def getNearestFlightDay(from: Int, to: Int, when: LocalDate,
                          interval: DateInterval): Future[Option[Calendar.FlightDay]]

  def getHasFlights(from: Int, to: Int, nights: Option[Int] = None): Future[Seq[Calendar.Document]]

  def getNoFlights(from: Int, to: Int, nights: Option[Int] = None): Future[Seq[Calendar.Document]]
}
