package ru.yandex.tours.services

import ru.yandex.tours.model.Prices.FlightMinPriceMatrix
import ru.yandex.tours.model.search.{BaseRequest, FlightSearchRequest}
import ru.yandex.tours.model.search.SearchResults.FlightSearchResult

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.02.16
 */
trait FlightSearchService {

  def searchFlights(request: FlightSearchRequest, canStartRequest: Boolean): Future[FlightSearchResult]

  def getFlightMatrix(request: FlightSearchRequest, from: Seq[Int], airports: Seq[String]): Future[FlightMinPriceMatrix]
}
