package ru.yandex.tours.services

import ru.yandex.tours.model.search.SearchResults.{HotelSearchResult, OfferSearchResult}
import ru.yandex.tours.model.search.{HotelSearchRequest, OfferSearchRequest}

import scala.concurrent.Future

trait HotelSearchService {
  def search(request: HotelSearchRequest,
             canStartRequest: Boolean,
             onlyFromLongCache: Boolean): Future[HotelSearchResult]

  def searchHotel(request: OfferSearchRequest,
                  canStartRequest: Boolean): Future[OfferSearchResult]

  def searchHotels(request: HotelSearchRequest,
                   hotelIds: Iterable[Int],
                   canStartRequest: Boolean): Future[Seq[OfferSearchResult]]
}
