package ru.yandex.tours.services

import org.joda.time.LocalDate
import ru.yandex.tours.model.Prices.{DirectionBestPrice, PriceGraph}
import ru.yandex.tours.model.search.HotelSearchRequest

import scala.concurrent.Future

trait MinPriceService {

  def getMinPriceGraph(request: HotelSearchRequest, graphLength: Int): Future[PriceGraph]

  def getMinPriceGraph(from: Int, to: Int,
                       when: LocalDate, nights: Int, ages: Seq[Int],
                       graphStart: LocalDate, graphEnd: LocalDate): Future[PriceGraph]

  def getDirectionMinPrice(from: Int, to: Int): Future[Option[DirectionBestPrice]]
}

object MinPriceService {
  val DEFAULT_GRAPH_LENGTH = 29

  val UNKNOWN_PRICE = -1
  val NO_TOURS = -2
}
