package ru.yandex.tours.services

import ru.yandex.tours.model.Prices.Recommendation
import ru.yandex.tours.model.search.WhereToGoRequest
import ru.yandex.tours.model.util.SortType.SortType
import ru.yandex.tours.personalization.UserIdentifiers

import scala.concurrent.Future

trait RecommendService {

  /** Returns directions recommendation for given user; used in showcase */
  def recommendTopDirections(userIdentifiers: UserIdentifiers, userRegion: Int): Future[Recommendation]

  /** Returns directions recommendation for given user; used on landing page */
  def recommendDirections(userIdentifiers: UserIdentifiers, userRegion: Int, sortBy: SortType): Future[Recommendation]

  /** Returns directions recommendation for given user */
  def recommendAllDirections(userIdentifiers: UserIdentifiers,
                             userRegion: Int, sortBy: SortType,
                             branding: Option[String]): Future[Recommendation]

  /** Returns directions recommendation for given user and country */
  def recommendResorts(countryId: Int,
                       userIdentifiers: UserIdentifiers,
                       userRegion: Int): Future[Recommendation]

  /** Returns directions recommendation for given user; used on thematic page */
  def recommendDirections(request: WhereToGoRequest, userIdentifiers: UserIdentifiers,
                          userRegion: Int, sortBy: SortType): Future[Recommendation]
}
