package ru.yandex.tours.services

import ru.yandex.tours.model.UserVisits
import ru.yandex.tours.model.search.HotelSearchRequest

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 01.06.16
 */
trait UserFavoritesService {

  def getFavorites(uid: Long): Future[Seq[UserVisits.Record]]

  def getFavorites(uid: Long, hotelIds: Seq[Int]): Future[Seq[UserVisits.Record]]

  def deleteFavorites(uid: Long, hotelId: Int): Future[Unit]

  def putVisit(uid: Long, hotelId: Int, request: HotelSearchRequest, data: UserVisits.PriceData): Future[Unit]
}
